import { Request, Response } from 'express';
import { greetingsService } from './service';

function hasFeature(vendor: any, featureKey: string): boolean {
  return vendor?.features?.includes(featureKey);
}

export const greetingsController = {
  // POST /greetings/templates
  async upsertTemplate(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor || !hasFeature(vendor, 'greeting_scheduler')) {
      return res.status(403).json({ error: 'Greeting scheduler not available on your plan.' });
    }
    const { data, error } = await greetingsService.upsertTemplate(vendor.id, req.body);
    if (error) return res.status(400).json({ error: error.message });
    return res.status(201).json({ success: true, data });
  },

  // GET /greetings/templates
  async getTemplates(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor || !hasFeature(vendor, 'greeting_scheduler')) {
      return res.status(403).json({ error: 'Greeting scheduler not available on your plan.' });
    }
    const { data, error } = await greetingsService.getTemplates(vendor.id);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // PATCH /greetings/settings
  async updateSettings(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor || !hasFeature(vendor, 'greeting_scheduler')) {
      return res.status(403).json({ error: 'Greeting scheduler not available on your plan.' });
    }
    const { data, error } = await greetingsService.updateSettings(vendor.id, req.body);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // GET /greetings/logs
  async getLogs(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor || !hasFeature(vendor, 'greeting_scheduler')) {
      return res.status(403).json({ error: 'Greeting scheduler not available on your plan.' });
    }
    const { type, status, date_range } = req.query;
    const filters: any = { type, status, date_range };
    const { data, error } = await greetingsService.getLogs(vendor.id, filters);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  }
}; 